/*
*
* Modified from sample code provided by Joey de Vries at https://learnopengl.com/,
* as permitted under CC BY-NC 4.0 license (https://creativecommons.org/licenses/by-nc/4.0/legalcode)
*
* Copyright (c) Joey de Vries (https://learnopengl.com/, https://twitter.com/JoeyDeVriez)
*/

#ifndef SHADER_H
#define SHADER_H

#include <string>
#include <fstream>
#include <sstream>
#include <iostream>
#include <vector>
#include <GL/glew.h>

class Shader {
public:
    GLuint Program;
    
    Shader(std::vector<GLchar*> vertexPaths, std::vector<GLchar*> fragmentPaths) {
        
        std::string vertexCode;
        std::string fragmentCode;
        std::ifstream vShaderFile;          // File handlers
        std::ifstream fShaderFile;
        
        std::stringstream vShaderStream, fShaderStream;

        for (int i = 0; i < vertexPaths.size(); i++) {
            try {
                // Open file, read buffer contents into streams
                vShaderFile.open(vertexPaths[i]);
                vShaderStream << vShaderFile.rdbuf();
                vShaderFile.close();
            }
            catch(std::ifstream::failure e) {
                std::cout << "Error: Vertex Shader " << i << ": File not successfully read" << std::endl;
            }
        }
        for (int i = 0; i < fragmentPaths.size(); i++) {
            try{
                fShaderFile.open(fragmentPaths[i]);
                fShaderStream << fShaderFile.rdbuf();
                fShaderFile.close();
            }
            catch(std::ifstream::failure e) {
                std::cout << "Error: Fragment Shader " << i << ": File not successfully read" << std::endl;
            }
        }
        vertexCode = vShaderStream.str();
        fragmentCode = fShaderStream.str();
        
        const GLchar* vShaderCode = vertexCode.c_str();
        const GLchar* fShaderCode = fragmentCode.c_str();
        

        // Compile
        
        GLuint vertexShader;
        vertexShader = glCreateShader(GL_VERTEX_SHADER);
        
        glShaderSource(vertexShader, 1, &vShaderCode, NULL);
        glCompileShader(vertexShader);
        
        // Check if compilation was successful
        GLint success;
        GLchar infoLog[512];
        glGetShaderiv(vertexShader, GL_COMPILE_STATUS, &success);
        if (!success) {
            glGetShaderInfoLog(vertexShader, 512, NULL, infoLog);
            std::cout << "Error: Shader::Vertex::Compilation Failed\n" << infoLog << std::endl;
        }
        
        GLuint fragmentShader;
        fragmentShader = glCreateShader(GL_FRAGMENT_SHADER);
        glShaderSource(fragmentShader, 1, &fShaderCode, NULL);
        glCompileShader(fragmentShader);
        glGetShaderiv(fragmentShader, GL_COMPILE_STATUS, &success);
        if (!success) {
            glGetShaderInfoLog(fragmentShader, 512, NULL, infoLog);
            std::cout << "Error: Shader::Fragment::Compilation Failed\n" << infoLog << std::endl;
        }
        
        this->Program = glCreateProgram();
        glAttachShader(this->Program, vertexShader);
        glAttachShader(this->Program, fragmentShader);
        glLinkProgram(this->Program);
        glGetProgramiv(this->Program, GL_LINK_STATUS, &success);
        if (!success) {
            glGetProgramInfoLog(this->Program, 512, NULL, infoLog);
            std::cout << "Error: Program::Shader::Linking Failed\n" << infoLog << std::endl;
        }
        
        glDeleteShader(vertexShader);
        glDeleteShader(fragmentShader);
            
    }
    
    void Use() {
        glUseProgram(this->Program);
    }
};

#endif
