#version 420 core
#extension GL_EXT_gpu_shader4 : enable

/* Declare input attributes */
layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoord;
layout (location = 3) in float vIndex;

out vec3 pos;
out vec3 N;
out vec3 T_color;
out vec2 txCoord;
out vec2 envCoord;

uniform mat4 view;
uniform mat4 projection;
uniform mat4 model;
uniform vec3 eyePos;
uniform int isLight;
uniform int isBackground;

uniform int lightID;
uniform vec3 lightSources[16];
uniform int IBL;

uniform float envRed[81];
uniform float envGreen[81];
uniform float envBlue[81];

uniform float lightScale;

uniform int showEnv;
uniform int showArea;

uniform sampler1D LUT_L2345;
uniform sampler1D LUT_L6789;
uniform samplerBuffer LUT_coeffs;

const float PI = 3.14159265f;
const float INV_PI = 0.31830988618f;

float[9] Legendre(float x) {
	float P[9];
	P[1] = x;

    vec4 texFetch = texture(LUT_L2345, x);
    
    P[2] = texFetch.x;
    P[3] = texFetch.y;
    P[4] = texFetch.z;
    P[5] = texFetch.w;

    vec4 texFetch2 = texture(LUT_L6789, x);
    
    P[6] = texFetch2.x;

    if (x < 0) {
        P[3] = -P[3];
        P[5] = -P[5];
    }
    
    return P;
}


float[9] boundary(float a, float b, float x, int maxN) {
    
    float B_n[9];
    
    float z = a*cos(x) + b*sin(x);
    float tmp1 = a*sin(x) - b*cos(x);
    float tmp2 = a*a+b*b-1;
    
    float P[9] = Legendre(z);
    float Pa[9] = Legendre(a);
    
    B_n[0] = x;
    B_n[1] = tmp1 + b;
    
	float D_next = 3 * B_n[1];
	float D_prev = x;
    
    for (int i = 2; i < maxN; i++) {
        float sf = 1.0/i;

        float C_n = (tmp1 * P[i-1]) + (tmp2 * D_prev) + ((i-1) * B_n[i-2]) + (b * Pa[i-1]);
        C_n *= sf;

		B_n[i] = (2*i-1) * C_n - (i - 1) * B_n[i - 2];
		B_n[i] *= sf;
		
		float temp = D_next;
		D_next = (2 * i + 1) * B_n[i] + D_prev;
		D_prev = temp;
    }
    
    return B_n;
}


float[9] evalLight(vec3 dir, vec3 verts[5], vec3 gam[5], vec3 gamP[5],
                    int maxN, int numVerts) {
    
    float total[9];

	float bound[9] = boundary(dot(dir, verts[0]), dot(dir, gamP[0]),
		acos(dot(verts[0], verts[1])), maxN);
	for (int n = 0; n < maxN; n++) {
		total[n] = bound[n] * dot(dir, gam[0]);
	}

    // i = 1
    bound = boundary(dot(dir, verts[1]), dot(dir, gamP[1]),
                                   acos(dot(verts[1], verts[2])), maxN);
    for (int n = 0; n < maxN; n++) {
        total[n] += bound[n] * dot(dir, gam[1]);
    }

    // i = 2
    bound = boundary(dot(dir, verts[2]), dot(dir, gamP[2]),
                                   acos(dot(verts[2], verts[3 % numVerts])), maxN);
    for (int n = 0; n < maxN; n++) {
        total[n] += bound[n] * dot(dir, gam[2]);
    }

    // i = 3
    if (numVerts >= 4) {
        bound = boundary(dot(dir, verts[3]), dot(dir, gamP[3]),
                                   acos(dot(verts[3], verts[4 % numVerts])), maxN);
        for (int n = 0; n < maxN; n++) {
            total[n] += bound[n] * dot(dir, gam[3]);
        }
    }

    if (numVerts >= 5) {
        bound = boundary(dot(dir, verts[4]), dot(dir, gamP[4]),
                                   acos(dot(verts[4], verts[5 % numVerts])), maxN);
        for (int n = 0; n < maxN; n++) {
            total[n] += bound[n] * dot(dir, gam[4]);
        }
    }

    float surf[9];
    surf[1] = 0.5 * total[0];
    surf[2] = 0.5 * total[1];
    surf[3] = dot(vec2(0.416667, 0.166667), vec2(total[2], surf[1]));
    surf[4] = dot(vec2(0.35, 0.3), vec2(total[3], surf[2]));
    surf[5] = dot(vec2(0.3, 0.4), vec2(total[4], surf[3]));
    surf[6] = dot(vec2(0.261905, 0.476190), vec2(total[5], surf[4]));
    surf[7] = dot(vec2(0.232143, 0.535714), vec2(total[6], surf[5]));
    surf[8] = dot(vec2(0.208333, 0.583333), vec2(total[7], surf[6]));

    
    return surf;
}

float solid_angle(vec3 verts[5], int numVerts) {
    float sa = 0;
    vec3 tmp1 = cross(verts[0], verts[numVerts-1]);
    vec3 tmp2 = cross(verts[0], verts[1]);
    sa += acos(dot(tmp1, tmp2) / (length(tmp1) * length(tmp2)));
    
    // Polygon will be at least a triangle
    // i = 1
    tmp1 = cross(verts[1], verts[0]);
    tmp2 = cross(verts[1], verts[2]);
    sa += acos(dot(tmp1, tmp2) / (length(tmp1) * length(tmp2)));

    // i = 2
    tmp1 = cross(verts[2], verts[1]);
    tmp2 = cross(verts[2], verts[3 % numVerts]);
    sa += acos(dot(tmp1, tmp2) / (length(tmp1) * length(tmp2)));

    if (numVerts >= 4) {
        tmp1 = cross(verts[3], verts[2]);
        tmp2 = cross(verts[3], verts[4 % numVerts]);
        sa += acos(dot(tmp1, tmp2) / (length(tmp1) * length(tmp2)));
    }
    if (numVerts >= 5) {
        tmp1 = cross(verts[4], verts[3]);
        tmp2 = cross(verts[4], verts[0]);   // for now let max vertices be 5
        sa += acos(dot(tmp1, tmp2) / (length(tmp1) * length(tmp2)));
    }

    sa -= (numVerts - 2) *PI;
    return sa;
}

float[81] polygonSH(const in vec3 L[5], int numVerts) {
    
    vec3 G[5];
    G[0] = normalize(cross(L[0], L[1]));
    G[1] = normalize(cross(L[1], L[2]));
    G[2] = normalize(cross(L[2], L[3 % numVerts]));
    
    vec3 Gp[5];
    Gp[0] = cross(G[0], L[0]);
    Gp[1] = cross(G[1], L[1]);
    Gp[2] = cross(G[2], L[2]);

    if (numVerts >= 4) {
        G[3] = normalize(cross(L[3], L[4 % numVerts]));
        Gp[3] = cross(G[3], L[3]);
    }
    if (numVerts >= 5) {
        G[4] = normalize(cross(L[4], L[5 % numVerts]));
        Gp[4] = cross(G[4], L[4]);
    }

    
    float SA = solid_angle(L, numVerts);
    int max_order = 8;
    
    float Lcoeff[81];
    for (int i = 0; i < 81; i++) {
        Lcoeff[i] = 0;
    }

    // Optimal lobe weights for bands 0 and 1
    Lcoeff[0] = 0.282095 * SA;

    float w20[9] = evalLight((vec3(0.866025, -0.500001, -0.000004)), L, G, Gp, max_order, numVerts);
    float w21[9] = evalLight((vec3(-0.759553, 0.438522, -0.480394)), L, G, Gp, max_order, numVerts);
    float w22[9] = evalLight((vec3(-0.000002, 0.638694, 0.769461)), L, G, Gp, max_order, numVerts);
    float w23[9] = evalLight((vec3(-0.000004, -1.000000, -0.000004)), L, G, Gp, max_order, numVerts);
    float w24[9] = evalLight((vec3(-0.000007, 0.000003, -1.000000)), L, G, Gp, max_order, numVerts);
    float w25[9] = evalLight((vec3(-0.000002, -0.638694, 0.769461)), L, G, Gp, max_order, numVerts);
    float w26[9] = evalLight((vec3(-0.974097, 0.000007, -0.226131)), L, G, Gp, max_order, numVerts);
    float w27[9] = evalLight((vec3(-0.000003, 0.907079, -0.420960)), L, G, Gp, max_order, numVerts);
    float w28[9] = evalLight((vec3(-0.960778, 0.000007, -0.277320)), L, G, Gp, max_order, numVerts);
    float w29[9] = evalLight((vec3(-0.000003, -0.907079, -0.420960)), L, G, Gp, max_order, numVerts);
    float w30[9] = evalLight((vec3(-0.451627, -0.451622, 0.769461)), L, G, Gp, max_order, numVerts);
    float w31[9] = evalLight((vec3(-0.000003, -0.806136, -0.591730)), L, G, Gp, max_order, numVerts);
    float w32[9] = evalLight((vec3(0.767864, 0.000000, 0.640613)), L, G, Gp, max_order, numVerts);
    float w33[9] = evalLight((vec3(-0.000003, 0.806136, -0.591730)), L, G, Gp, max_order, numVerts);
    float w34[9] = evalLight((vec3(-0.553127, 0.319344, 0.769461)), L, G, Gp, max_order, numVerts);
    float w35[9] = evalLight((vec3(0.707105, 0.707108, -0.000004)), L, G, Gp, max_order, numVerts);
    float w36[9] = evalLight((vec3(0.925820, 0.000000, 0.377964)), L, G, Gp, max_order, numVerts);

	Lcoeff[1] = dot(vec3(2.1995339, 2.50785367, 1.56572711), vec3(w20[1], w21[1], w22[1]));
	Lcoeff[2] = dot(vec2(-1.82572523, -2.08165037), vec2(w20[1], w21[1]));
	Lcoeff[3] = dot(vec3(2.42459869, 1.44790525, 0.90397552), vec3(w20[1], w21[1], w22[1]));

	Lcoeff[4] = dot(vec3(-1.33331385, -0.66666684, -0.99999606), vec3(w20[2], w23[2], w24[2]));
	Lcoeff[5] = dot(vec3(1.1747938, -0.47923799, -0.69556433), vec3(w22[2], w23[2], w24[2]));
	Lcoeff[6] = w24[2];
	Lcoeff[7] = dot(vec3(-1.21710396, 1.58226094, 0.67825711), vec3(w20[2], w21[2], w22[2]));
	Lcoeff[7] += dot(vec2(-0.27666329, -0.76671491), vec2(w23[2], w24[2]));
	Lcoeff[8] = dot(vec2(-1.15470843, -0.57735948), vec2(w23[2], w24[2]));
    
    Lcoeff[9] += dot(vec3(-0.418128476395, 1.04704832111, 0.418135743058), vec3(w22[3], w23[3], w25[3]));
    Lcoeff[10] += dot(vec3(-0.217803921828, 1.61365275071, -0.0430709310435), vec3(w20[3], w21[3], w22[3]));
    Lcoeff[10] += dot(vec3(-1.08141635635, 0.730013109257, -0.906789272616), vec3(w23[3], w24[3], w25[3]));
    Lcoeff[11] += dot(vec3(0.539792926181, 0.281276817357, -0.53979650602), vec3(w22[3], w23[3], w25[3]));
    Lcoeff[12] += -1.00000000026 * w24[3];
    Lcoeff[13] += dot(vec4(-1.88563738164, 0.934959388519, -1.39846078802, -0.934977410564), vec4(w20[3], w22[3], w23[3], w25[3]));
    Lcoeff[14] += dot(vec3(-0.822588107798, 0.0250955547337, -0.822583092847), vec3(w22[3], w24[3], w25[3]));
    Lcoeff[15] += dot(vec3(-1.14577301943, 1.03584677217, -0.849735800355), vec3(w20[3], w22[3], w23[3]));
    Lcoeff[15] += dot(vec3(-0.438905584229, -0.100364975081, -1.36852983602), vec3(w24[3], w25[3], w26[3]));
    Lcoeff[16] += dot(vec3(-0.694140591095, -1.46594132085, -3.76291455607), vec3(w20[4], w21[4], w22[4]));
    Lcoeff[16] += dot(vec3(-4.19771773174, -4.41452625915, -5.21937739623), vec3(w23[4], w24[4], w25[4]));
    Lcoeff[16] += dot(vec3(30.1096083902, -0.582891410482, -25.58700736), vec3(w26[4], w27[4], w28[4]));
    Lcoeff[17] += dot(vec4(-0.776237001754, -0.497694700099, 0.155804529921, 0.255292423057), vec4(w22[4], w23[4], w24[4], w25[4]));
    Lcoeff[17] += dot(vec3(-0.00123151211175, 0.86352262597, 0.00106337156796), vec3(w26[4], w27[4], w28[4]));
    Lcoeff[18] += dot(vec3(1.14732747049, -1.93927453351, -4.97819284362), vec3(w20[4], w21[4], w22[4]));
    Lcoeff[18] += dot(vec3(-4.52057526927, -7.00211058681, -6.90497275343), vec3(w23[4], w24[4], w25[4]));
    Lcoeff[18] += dot(vec3(39.8336896922, -0.771083185249, -33.8504871326), vec3(w26[4], w27[4], w28[4]));
    Lcoeff[19] += dot(vec3(0.392392485498, -0.469375435363, 0.146862690526), vec3(w22[4], w23[4], w24[4]));
    Lcoeff[19] += dot(vec2(-0.883760925422, 0.81431736181), vec2(w25[4], w27[4]));
    Lcoeff[20] += dot(vec3(1.00015572278, -0.00110374505123, 0.000937958411459), vec3(w24[4], w26[4], w28[4]));
    Lcoeff[21] += dot(vec3(7.51111593422, 6.56318513992, 7.31626822687), vec3(w22[4], w23[4], w24[4]));
    Lcoeff[21] += dot(vec3(7.51109857163, -51.4260730066, 43.7016908482), vec3(w25[4], w26[4], w28[4]));
    Lcoeff[22] += dot(vec4(-0.61727564343, 0.205352092062, -0.461764665742, -0.617286413191), vec4(w22[4], w23[4], w24[4], w25[4]));
    Lcoeff[23] += dot(vec3(6.71336600734, 5.24419547627, 7.13550000457), vec3(w22[4], w23[4], w24[4]));
    Lcoeff[23] += dot(vec3(6.71337558899, -51.8339912003, 45.9921960339), vec3(w25[4], w26[4], w28[4]));
    Lcoeff[24] += dot(vec3(0.466450172383, 1.19684418958, -0.158210638771), vec3(w22[4], w23[4], w24[4]));
    Lcoeff[24] += dot(vec2(0.466416144347, 0.000906975300098), vec2(w25[4], w26[4]));

    Lcoeff[25] += dot(vec3(0.133023249281, -0.760308430874, -0.132834964007), vec3(w22[5], w23[5], w25[5]));
    Lcoeff[25] += dot(vec2(0.518450012982, -0.518506289002), vec2(w27[5], w29[5]));
    Lcoeff[26] += dot(vec4(-5.14050071652, 1.83087149155, 1.78238433161, 2.02177436206), vec4(w20[5], w21[5], w22[5], w23[5]));
    Lcoeff[26] += dot(vec4(-6.37830163415, 7.15050958772, -11.4689716172, -1.81357297097), vec4(w24[5], w25[5], w26[5], w27[5]));
    Lcoeff[26] += dot(vec3(18.797061252, -0.985019094169, 0.739867930848), vec3(w28[5], w29[5], w30[5]));
    Lcoeff[27] += dot(vec3(-0.805270111174, -0.127526187772, 0.805305675495), vec3(w22[5], w23[5], w25[5]));
    Lcoeff[27] += dot(vec2(0.0355293099825, -0.0355325587066), vec2(w27[5], w29[5]));
    Lcoeff[28] += dot(vec4(-3.33455180799, 0.473764461749, 1.29183304086, -4.33925590117), vec4(w20[5], w22[5], w23[5], w24[5]));
    Lcoeff[28] += dot(vec3(5.75047620831, -11.0487024546, -1.39272172093), vec3(w25[5], w26[5], w27[5]));
    Lcoeff[28] += dot(vec3(15.5105028631, -1.49843129853, 1.60213069355), vec3(w28[5], w29[5], w30[5]));
    Lcoeff[29] += dot(vec3(0.677072222771, -0.826014233465, -0.67715296313), vec3(w22[5], w23[5], w25[5]));
    Lcoeff[29] += dot(vec2(-0.789705431563, 0.789736851279), vec2(w27[5], w29[5]));
    Lcoeff[30] += -0.999908682153 * w24[5];
    Lcoeff[31] += dot(vec3(3.96619174114, -0.19550135503, -1.58642864103), vec3(w20[5], w22[5], w23[5]));
    Lcoeff[31] += dot(vec3(3.47400073804, -5.20598671543, 5.5486664469), vec3(w24[5], w25[5], w26[5]));
    Lcoeff[31] += dot(vec3(0.897822456022, -10.1396069573, 1.11892856733), vec3(w27[5], w28[5], w29[5]));
    Lcoeff[32] += dot(vec3(-0.616617693524, 0.650557423215, -0.616596023515), vec3(w22[5], w24[5], w25[5]));
    Lcoeff[32] += dot(vec2(-0.277058316558, -0.277048507641), vec2(w27[5], w29[5]));
    Lcoeff[33] += dot(vec3(5.0039871462, -1.088320635, -2.00153810596), vec3(w20[5], w22[5], w23[5]));
    Lcoeff[33] += dot(vec3(5.28613602468, -7.40986154696, 16.2642361284), vec3(w24[5], w25[5], w26[5]));
    Lcoeff[33] += dot(vec3(1.55989830441, -22.7165927272, 1.83889101022), vec3(w27[5], w28[5], w29[5]));
    Lcoeff[34] += dot(vec3(0.405328070694, -0.0469925687439, 0.405339520518), vec3(w22[5], w24[5], w25[5]));
    Lcoeff[34] += dot(vec2(-0.608726965055, -0.608728247749), vec2(w27[5], w29[5]));
    Lcoeff[35] += dot(vec3(1.09103970866, -1.17451461211, -0.436442419407), vec3(w20[5], w22[5], w23[5]));
    Lcoeff[35] += dot(vec3(2.3973180386, -2.55290709278, 3.82908736876), vec3(w24[5], w25[5], w26[5]));
    Lcoeff[35] += dot(vec3(0.665431405575, -6.99714715269, 0.726274850285), vec3(w27[5], w28[5], w29[5]));

    Lcoeff[36] += dot(vec4(110.407306498, 121.297251387, 263.985067401, 110.725812649), vec4(w20[6], w21[6], w22[6], w23[6]));
    Lcoeff[36] += dot(vec3(322.033930881, 162.479577242, 1755.80451307), vec3(w24[6], w25[6], w26[6]));
    Lcoeff[36] += dot(vec3(-14.7032957811, -1553.88668558, 64.4632133415), vec3(w27[6], w28[6], w29[6]));
    Lcoeff[36] += dot(vec3(-22.0873701656, -61.3998433111, 187.359713154), vec3(w30[6], w31[6], w32[6]));
    Lcoeff[37] += dot(vec4(-0.00111818967084, -0.00123422458098, 0.336682549226, -0.00132691821183), vec4(w20[6], w21[6], w22[6], w23[6]));
    Lcoeff[37] += dot(vec4(-0.0034983376219, -0.341167543299, -0.01890204627, -0.723728647079), vec4(w24[6], w25[6], w26[6], w27[6]));
    Lcoeff[37] += dot(vec3(0.0167673427229, 0.723491153889, -0.00198206765087), vec3(w28[6], w29[6], w32[6]));
    Lcoeff[38] += dot(vec4(15.3227047788, 14.2753461798, 12.4149247001, 1.340434285), vec4(w20[6], w21[6], w22[6], w23[6]));
    Lcoeff[38] += dot(vec3(16.4050796616, 5.20690955596, 93.7391441162), vec3(w24[6], w25[6], w26[6]));
    Lcoeff[38] += dot(vec3(-5.70151762203, -78.7068450207, 1.01952589216), vec3(w27[6], w28[6], w29[6]));
    Lcoeff[38] += dot(vec3(-0.0124081990428, -2.71358001541, 13.8096132986), vec3(w30[6], w31[6], w32[6]));
    Lcoeff[39] += dot(vec4(-0.00117951166106, -1.68851028063, 0.499987655626, 0.0811287014828), vec4(w21[6], w22[6], w23[6], w24[6]));
    Lcoeff[39] += dot(vec4(0.924525864736, -0.0180671469572, -0.53953363757, 0.0160213923983), vec4(w25[6], w26[6], w27[6], w28[6]));
    Lcoeff[39] += dot(vec3(-1.22120890317, 1.93471815616, -0.00189817210815), vec3(w29[6], w31[6], w32[6]));
    Lcoeff[40] += dot(vec4(14.2349433166, 15.6374252438, 13.8493129894, 2.43692566103), vec4(w20[6], w21[6], w22[6], w23[6]));
    Lcoeff[40] += dot(vec3(16.7738688981, 5.95348061509, 102.676997666), vec3(w24[6], w25[6], w26[6]));
    Lcoeff[40] += dot(vec3(-4.85746148998, -86.2109081623, 2.50489677852), vec3(w27[6], w28[6], w29[6]));
    Lcoeff[40] += dot(vec3(-0.0135530622167, -2.97256381466, 15.1268484906), vec3(w30[6], w31[6], w32[6]));
    Lcoeff[41] += dot(vec4(0.0011471762337, 0.00134013654614, 1.90642287302, -0.949799062166), vec4(w20[6], w21[6], w22[6], w23[6]));
    Lcoeff[41] += dot(vec4(-0.156687609791, -0.460381337914, 0.0194055069076, 0.614031832908), vec4(w24[6], w25[6], w26[6], w27[6]));
    Lcoeff[41] += dot(vec4(-0.017163787015, 2.72661250835, -3.67080744599, 0.00207762117982), vec4(w28[6], w29[6], w31[6], w32[6]));
    Lcoeff[42] += dot(vec3(1.00039252313, 0.00181905245706, -0.00166508494552), vec3(w24[6], w26[6], w28[6]));
    Lcoeff[43] += dot(vec4(0.0133463019389, 0.0153654992493, 8.78743258451, 5.81522851174), vec4(w20[6], w21[6], w22[6], w23[6]));
    Lcoeff[43] += dot(vec3(12.5550974713, 8.77413125608, 58.4922368204), vec3(w24[6], w25[6], w26[6]));
    Lcoeff[43] += dot(vec3(1.34231351205, -53.541181195, 1.35225002587), vec3(w27[6], w28[6], w29[6]));
    Lcoeff[43] += dot(vec3(-0.0032149390263, -0.00792693014645, 3.26902843874), vec3(w30[6], w31[6], w32[6]));
    Lcoeff[44] += dot(vec3(-0.565026447733, -0.440924426872, -0.803140025769), vec3(w22[6], w23[6], w24[6]));
    Lcoeff[44] += dot(vec3(-0.565750951282, 0.0106971854579, 0.465219496817), vec3(w25[6], w26[6], w27[6]));
    Lcoeff[44] += dot(vec3(-0.00942810590012, 0.465803316978, 0.00121182174646), vec3(w28[6], w29[6], w32[6]));
    Lcoeff[45] += dot(vec4(0.0120591281871, 0.0140081081238, 8.84231008623, 6.30335116571), vec4(w20[6], w21[6], w22[6], w23[6]));
    Lcoeff[45] += dot(vec3(13.3925214762, 8.83016166486, 63.6145973482), vec3(w24[6], w25[6], w26[6]));
    Lcoeff[45] += dot(vec3(1.11030347967, -59.2232957105, 1.11930309013), vec3(w27[6], w28[6], w29[6]));
    Lcoeff[45] += dot(vec3(-0.00299575240939, -0.00721839822023, 4.87051865893), vec3(w30[6], w31[6], w32[6]));
    Lcoeff[46] += dot(vec3(0.651047411165, -0.429335217103, 0.106976359799), vec3(w22[6], w23[6], w24[6]));
    Lcoeff[46] += dot(vec3(0.650368759846, 0.0109636003151, 0.306691437259), vec3(w25[6], w26[6], w27[6]));
    Lcoeff[46] += dot(vec3(-0.00965411398733, 0.307235947971, 0.00120365403511), vec3(w28[6], w29[6], w32[6]));
    Lcoeff[47] += dot(vec4(0.00324439166172, 0.00369123568018, 0.800772124437, 1.63137398167), vec4(w20[6], w21[6], w22[6], w23[6]));
    Lcoeff[47] += dot(vec4(1.43566157126, 0.797501947007, 9.03263537993, 0.535950980597), vec4(w24[6], w25[6], w26[6], w27[6]));
    Lcoeff[47] += dot(vec4(-7.2757158051, 0.538410039638, -0.00198357688491, 1.7022272091), vec4(w28[6], w29[6], w31[6], w32[6]));
    Lcoeff[48] += dot(vec4(0.00156677824614, 0.00170502607019, -0.0939749600966, -0.872048853744), vec4(w20[6], w21[6], w22[6], w23[6]));
    Lcoeff[48] += dot(vec4(0.00440208146779, -0.0953605716075, 0.0240666470029, -0.540590886575), vec4(w24[6], w25[6], w26[6], w27[6]));
    Lcoeff[48] += dot(vec3(-0.0212662429579, -0.539478586759, 0.00260075917574), vec3(w28[6], w29[6], w32[6]));

    Lcoeff[49] += dot(vec3(-0.0701805272893, 0.98255354265, 0.0686440478357), vec3(w22[7], w23[7], w25[7]));
    Lcoeff[49] += dot(vec3(-0.550199211871, 0.550738563391, -0.00124904263303), vec3(w27[7], w29[7], w33[7]));
    Lcoeff[50] += dot(vec4(-37.3285759367, -5.7563959375, 44.5510845679, 53.5563319108), vec4(w20[7], w22[7], w23[7], w24[7]));
    Lcoeff[50] += dot(vec4(-114.931760993, 26.7620910072, 76.1871627236, 18.7459525504), vec4(w25[7], w26[7], w27[7], w28[7]));
    Lcoeff[50] += dot(vec3(-32.9000483785, -7.89959890218, 45.2203492106), vec3(w29[7], w30[7], w31[7]));
    Lcoeff[50] += dot(vec3(24.5638783781, -109.38781242, 0.00341946781379), vec3(w32[7], w33[7], w34[7]));
    Lcoeff[51] += dot(vec3(0.60312464974, 0.514140412839, -0.601853534614), vec3(w22[7], w23[7], w25[7]));
    Lcoeff[51] += dot(vec2(0.456751969399, -0.457204648754), vec2(w27[7], w29[7]));
    Lcoeff[52] += dot(vec4(-5.52955347687, -4.34348722462, 4.3438125575, 7.88948108037), vec4(w20[7], w22[7], w23[7], w24[7]));
    Lcoeff[52] += dot(vec3(-12.6234155916, 6.34843469899, 6.2109893889), vec3(w25[7], w26[7], w27[7]));
    Lcoeff[52] += dot(vec3(-0.00429379248923, -0.756126464499, 0.424399863695), vec3(w28[7], w29[7], w31[7]));
    Lcoeff[52] += dot(vec3(3.60062053248, -9.77362846891, -2.02096723974), vec3(w32[7], w33[7], w34[7]));
    Lcoeff[53] += dot(vec4(-1.84219028026, -0.800561174358, 1.84228914268, -1.76578138065), vec4(w22[7], w23[7], w25[7], w27[7]));
    Lcoeff[53] += dot(vec3(1.76570658332, -2.58447322137, 2.58446953723), vec3(w29[7], w31[7], w33[7]));
    Lcoeff[54] += dot(vec4(4.28585473464, -5.57083870671, 3.88299131276, -1.21598103809), vec4(w20[7], w21[7], w22[7], w23[7]));
    Lcoeff[54] += dot(vec4(-1.02579013048, 0.421658914765, -6.27175023832, 1.89012154573), vec4(w24[7], w25[7], w26[7], w27[7]));
    Lcoeff[54] += dot(vec3(0.0116877614083, -3.62740434708, -0.00168583412282), vec3(w28[7], w29[7], w30[7]));
    Lcoeff[54] += dot(vec3(2.90947495533, 2.71420375237, -1.15571591609), vec3(w31[7], w32[7], w33[7]));
    Lcoeff[55] += dot(vec4(1.33143227971, 1.12171235628, -1.33021306817, 2.17150195324), vec4(w22[7], w23[7], w25[7], w27[7]));
    Lcoeff[55] += dot(vec3(-2.17190603892, 2.68546413814, -2.68475126266), vec3(w29[7], w31[7], w33[7]));
    Lcoeff[56] += -0.999785087625 * w24[7];
    Lcoeff[57] += dot(vec4(-4.98353234343, -0.60335722233, 5.06180432247, 5.983807289), vec4(w20[7], w22[7], w23[7], w24[7]));
    Lcoeff[57] += dot(vec4(-12.4335970683, 5.62509069724, 8.45051745261, -0.00408078300172), vec4(w25[7], w26[7], w27[7], w28[7]));
    Lcoeff[57] += dot(vec4(-2.8882608379, 4.59925710784, 2.29940628779, -11.9972155397), vec4(w29[7], w31[7], w32[7], w33[7]));
    Lcoeff[58] += dot(vec4(-0.87292844039, 0.853086268401, -0.872716127179, 0.548554049149), vec4(w22[7], w24[7], w25[7], w27[7]));
    Lcoeff[58] += dot(vec3(0.548734794611, -1.07309588446, -1.07281880178), vec3(w29[7], w31[7], w33[7]));
    Lcoeff[59] += dot(vec4(-6.71247285675, -2.43207100005, 6.81762410543, 9.33449029193), vec4(w20[7], w22[7], w23[7], w24[7]));
    Lcoeff[59] += dot(vec3(-18.3657135974, 2.02534151283, 11.8803536762), vec3(w25[7], w26[7], w27[7]));
    Lcoeff[59] += dot(vec3(6.40090944988, -3.39122648096, 0.00113658729748), vec3(w28[7], w29[7], w30[7]));
    Lcoeff[59] += dot(vec3(5.38458251565, 4.50642495235, -16.9684952577), vec3(w31[7], w32[7], w33[7]));
    Lcoeff[60] += dot(vec3(0.8151794721, -0.201027115556, 0.81519502336), vec3(w22[7], w24[7], w25[7]));
    Lcoeff[60] += dot(vec2(0.181660069418, 0.181680334223), vec2(w27[7], w29[7]));
    Lcoeff[61] += dot(vec4(-1.90839389632, -1.76712931026, 1.93832899575, 3.89588368627), vec4(w20[7], w22[7], w23[7], w24[7]));
    Lcoeff[61] += dot(vec4(-6.29727952971, 2.48144221527, 3.24427850885, -1.09768856807), vec4(w25[7], w26[7], w27[7], w29[7]));
    Lcoeff[61] += dot(vec3(0.748671845519, 2.61667793247, -5.60663032021), vec3(w31[7], w32[7], w33[7]));
    Lcoeff[62] += dot(vec4(-0.270895144417, -0.271153759143, 0.820526195092, 0.820278327508), vec4(w22[7], w25[7], w27[7], w29[7]));
    Lcoeff[63] += dot(vec4(-0.00126785006862, 1.20665045598, 0.00162281551801, -0.963247933527), vec4(w20[7], w22[7], w23[7], w24[7]));
    Lcoeff[63] += dot(vec4(1.20267970448, -1.77208455178, -0.986776039728, 0.0024149973414), vec4(w25[7], w26[7], w27[7], w28[7]));
    Lcoeff[63] += dot(vec4(-0.990721508828, 0.583109464442, 0.451361607718, 0.577458802184), vec4(w29[7], w31[7], w32[7], w33[7]));

    Lcoeff[64] += dot(vec4(1.53749427566, 0.909584774471, -12.8120323661, 0.431904370785), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[64] += dot(vec4(-12.3258435464, -13.1146498411, 88.2060200532, -12.2132842255), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[64] += dot(vec3(-111.819986738, -11.6817657491, 0.404047756365), vec3(w28[8], w29[8], w30[8]));
    Lcoeff[64] += dot(vec3(12.0467189584, -0.994477402231, 12.180903566), vec3(w31[8], w32[8], w33[8]));
    Lcoeff[64] += dot(vec3(-0.509165463671, 0.214834626621, 32.2725793151), vec3(w34[8], w35[8], w36[8]));
    Lcoeff[65] += dot(vec4(0.02820380227, -0.0747431249236, 2.92512698977, -0.112167836437), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[65] += dot(vec4(2.79794117593, 3.55063984248, -21.5072045956, 3.93193106867), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[65] += dot(vec3(27.3991444823, 1.94595833674, 0.0115842799386), vec3(w28[8], w29[8], w30[8]));
    Lcoeff[65] += dot(vec3(-2.64814758249, 0.42709474181, -2.94245915297), vec3(w31[8], w32[8], w33[8]));
    Lcoeff[65] += dot(vec3(-0.0686794362676, 0.00655079684495, -7.93317808252), vec3(w34[8], w35[8], w36[8]));
    Lcoeff[66] += dot(vec4(0.391342450648, -1.02492254371, 125.326506712, -4.6445432842), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[66] += dot(vec4(109.33702209, 125.208534258, -851.51589026, 114.502675185), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[66] += dot(vec3(1087.75897489, 113.224769946, -1.50797447135), vec3(w28[8], w29[8], w30[8]));
    Lcoeff[66] += dot(vec3(-108.466362134, 18.4164681113, -109.583142595), vec3(w31[8], w32[8], w33[8]));
    Lcoeff[66] += dot(vec3(-0.937471108497, 1.39128181347, -316.5905216), vec3(w34[8], w35[8], w36[8]));
    Lcoeff[67] += dot(vec4(0.119153299569, -0.315481464262, 14.0614420783, -0.473010097461), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[67] += dot(vec4(11.7965154114, 13.2422133423, -90.6761509524, 12.8951524656), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[67] += dot(vec3(115.516527355, 11.8873201428, 0.049144869583), vec3(w28[8], w29[8], w30[8]));
    Lcoeff[67] += dot(vec3(-11.1652789635, 1.80037152648, -12.4058801396), vec3(w31[8], w32[8], w33[8]));
    Lcoeff[67] += dot(vec3(-0.289812743287, 0.0276724657153, -33.4465000918), vec3(w34[8], w35[8], w36[8]));
    Lcoeff[68] += dot(vec4(-0.0291848617478, 0.245516477549, 118.116347051, -3.38172094147), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[68] += dot(vec4(104.366969862, 117.524021629, -813.126174282, 108.739088105), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[68] += dot(vec3(1040.02520445, 108.127023707, -1.06230167797), vec3(w28[8], w29[8], w30[8]));
    Lcoeff[68] += dot(vec3(-102.174880088, 18.9774125832, -103.213055714), vec3(w31[8], w32[8], w33[8]));
    Lcoeff[68] += dot(vec3(-1.81889823372, -0.555751123944, -303.112465503), vec3(w34[8], w35[8], w36[8]));
    Lcoeff[69] += dot(vec4(-0.395035183387, 1.04586983477, -45.5572484204, 1.56813129402), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[69] += dot(vec4(-39.1074829737, -44.9591485736, 300.607189459, -41.1873913838), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[69] += dot(vec3(-382.957356484, -40.9708031646, -0.162930068218), vec3(w28[8], w29[8], w30[8]));
    Lcoeff[69] += dot(vec3(39.2832393404, -5.96855234135, 38.8592527753), vec3(w31[8], w32[8], w33[8]));
    Lcoeff[69] += dot(vec3(0.960789726517, -0.0917705056566, 110.880958708), vec3(w34[8], w35[8], w36[8]));
    Lcoeff[70] += dot(vec4(0.456810706057, -1.19610219984, 145.14169054, -3.60731438449), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[70] += dot(vec4(128.010827764, 145.004047784, -993.769284631, 134.16474103), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[70] += dot(vec3(1269.47881154, 132.673316481, -1.75982783541), vec3(w28[8], w29[8], w30[8]));
    Lcoeff[70] += dot(vec3(-125.717600801, 21.4930188871, -127.020961656), vec3(w31[8], w32[8], w33[8]));
    Lcoeff[70] += dot(vec3(-1.09412783044, -0.92615123861, -369.479614638), vec3(w34[8], w35[8], w36[8]));
    Lcoeff[71] += dot(vec4(0.367481338147, -0.972917666468, 41.653343463, -1.45876523059), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[71] += dot(vec4(36.3807277786, 42.5517382838, -279.647500028, 38.6375231848), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[71] += dot(vec3(356.255877922, 37.7922040017, 0.151565737021), vec3(w28[8], w29[8], w30[8]));
    Lcoeff[71] += dot(vec3(-35.8358023732, 5.55242780488, -36.8581681038), vec3(w31[8], w32[8], w33[8]));
    Lcoeff[71] += dot(vec3(-0.893804648761, 0.0853291679856, -103.149863518), vec3(w34[8], w35[8], w36[8]));
    Lcoeff[72] += dot(vec4(0.00188542464872, 1.00165569552, 0.00187041518417, -0.0123197787928), vec4(w22[8], w24[8], w25[8], w26[8]));
    Lcoeff[72] += dot(vec3(0.00169115843328, 0.0156826399574, 0.00170503250921), vec3(w27[8], w28[8], w29[8]));
    Lcoeff[72] += dot(vec3(-0.00167433376791, -0.00165711826159, -0.00449049345544), vec3(w31[8], w33[8], w36[8]));
    Lcoeff[73] += dot(vec4(0.00405256436808, -0.00262582264354, 63.550287794, -2.30613108952), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[73] += dot(vec4(55.7252304106, 63.5538445478, -418.347495226, 57.5308076948), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[73] += dot(vec4(532.655148546, 57.521374147, -0.00352791192438, -55.9572413108), vec4(w28[8], w29[8], w30[8], w31[8]));
    Lcoeff[73] += dot(vec4(7.99539527162, -55.9579600129, 0.00456856106269, -152.990616437), vec4(w32[8], w33[8], w35[8], w36[8]));
    Lcoeff[74] += dot(vec4(-0.881394274788, 0.473165408429, -0.942062797089, -0.881378435578), vec4(w22[8], w23[8], w24[8], w25[8]));
    Lcoeff[74] += dot(vec4(0.0177306070586, -1.01197251544, -0.0226882112384, -1.0120079567), vec4(w26[8], w27[8], w28[8], w29[8]));
    Lcoeff[74] += dot(vec3(1.4069429521, 1.40690203994, 0.00662191089822), vec3(w31[8], w33[8], w36[8]));
    Lcoeff[75] += dot(vec4(0.00641782135735, -0.00388890880837, 92.7897539783, -2.83263971836), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[75] += dot(vec4(81.5477534167, 92.7953548562, -635.681288259, 84.4996736106), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[75] += dot(vec4(814.870318064, 84.4851189109, -0.00533844276317, -81.4656461897), vec4(w28[8], w29[8], w30[8], w31[8]));
    Lcoeff[75] += dot(vec4(13.9482979732, -81.4667603321, 0.00699793551893, -238.52207368), vec4(w32[8], w33[8], w35[8], w36[8]));
    Lcoeff[76] += dot(vec4(1.17167184082, -0.106264795054, 0.271482557427, 1.17166744313), vec4(w22[8], w23[8], w24[8], w25[8]));
    Lcoeff[76] += dot(vec4(-0.00997814053713, 0.393888061274, 0.0127991226512, 0.393896718706), vec4(w26[8], w27[8], w28[8], w29[8]));
    Lcoeff[76] += dot(vec3(-0.89395978918, -0.893949593311, -0.00378935185386), vec3(w31[8], w33[8], w36[8]));
    Lcoeff[77] += dot(vec4(0.0026121874954, -0.00155417390692, 34.9602498365, -0.615998044572), vec4(w20[8], w21[8], w22[8], w23[8]));
    Lcoeff[77] += dot(vec4(30.2173293689, 34.9625301883, -252.286117615, 32.1648727481), vec4(w24[8], w25[8], w26[8], w27[8]));
    Lcoeff[77] += dot(vec4(324.269439477, 32.1590190028, -0.00211835901653, -29.8023247437), vec4(w28[8], w29[8], w30[8], w31[8]));
    Lcoeff[77] += dot(vec4(7.39874675695, -29.8028199408, 0.00279330634013, -96.341082571), vec4(w32[8], w33[8], w35[8], w36[8]));
    Lcoeff[78] += dot(vec4(-0.387527707899, 0.416763243365, -0.0286688282881, -0.387525584935), vec4(w22[8], w23[8], w24[8], w25[8]));
    Lcoeff[78] += dot(vec4(-0.0105262321023, -0.295992700404, 0.0134560889041, -0.296013229931), vec4(w26[8], w27[8], w28[8], w29[8]));
    Lcoeff[78] += dot(vec3(-0.345151726145, -0.345174064069, -0.00393134444984), vec3(w31[8], w33[8], w36[8]));
    Lcoeff[79] += dot(vec4(4.90103610639, -1.21333206278, 4.02714177428, 4.90129554805), vec4(w22[8], w23[8], w24[8], w25[8]));
    Lcoeff[79] += dot(vec4(-28.4484536271, 3.91036185913, 37.1656352206, 3.90974932967), vec4(w26[8], w27[8], w28[8], w29[8]));
    Lcoeff[79] += dot(vec4(-3.90148035383, 1.47547837629, -3.90145837153, -9.91757330562), vec4(w31[8], w32[8], w33[8], w36[8]));
    Lcoeff[80] += dot(vec4(0.0684332108322, 1.06483675683, -0.00153837235285, 0.0684374426626), vec4(w22[8], w23[8], w24[8], w25[8]));
    Lcoeff[80] += dot(vec4(-0.0166644698234, 0.593587849063, 0.0213264820211, 0.593536664019), vec4(w26[8], w27[8], w28[8], w29[8]));
    Lcoeff[80] += dot(vec3(-0.0440627637216, -0.0441185577727, -0.00620665050047), vec3(w31[8], w33[8], w36[8]));
    return Lcoeff;
    
}



float get_transfer_color(float Lc[81]) {
    // Add envmap coefficient colors

    int vInd = int(vIndex) * 21;
        
    float col_0 = dot(texelFetchBuffer(LUT_coeffs, vInd ).x, vec4(Lc[0], Lc[1], Lc[2], Lc[3]).x);
    float col_1 = 0.4886025 * dot(texelFetchBuffer(LUT_coeffs, vInd ).yzw, vec4(Lc[0], Lc[1], Lc[2], Lc[3]).yzw);

    float col_2 = dot(texelFetchBuffer(LUT_coeffs, vInd + 1 ), vec4(Lc[4], Lc[5], Lc[6], Lc[7]));
    vec4 temp = texelFetchBuffer(LUT_coeffs, vInd + 2 );
    col_2 += temp.x * Lc[8];
    col_2 *= 0.6307831;

    float col_3 = dot(temp.yzw, vec3(Lc[9], Lc[10], Lc[11]));
    col_3 += dot(texelFetchBuffer(LUT_coeffs, vInd + 3 ), vec4(Lc[12], Lc[13], Lc[14], Lc[15]));
    col_3 *= 0.746353;
    
    float col_4 = dot(texelFetchBuffer(LUT_coeffs, vInd + 4 ), vec4(Lc[16], Lc[17], Lc[18], Lc[19])) +
        dot(texelFetchBuffer(LUT_coeffs, vInd + 5 ), vec4(Lc[20], Lc[21], Lc[22], Lc[23]));

    vec4 temp2 = texelFetchBuffer(LUT_coeffs, vInd + 6 );
    col_4 += temp2.x * Lc[24];
    col_4 *= 0.8462844; 
    
    float col_5 = dot(temp2.yzw, vec3(Lc[25], Lc[26], Lc[27])) +
        dot(texelFetchBuffer(LUT_coeffs, vInd + 7 ), vec4(Lc[28], Lc[29], Lc[30], Lc[31])) +
        dot(texelFetchBuffer(LUT_coeffs, vInd + 8 ), vec4(Lc[32], Lc[33], Lc[34], Lc[35]));
    col_5 *= 0.9356026; 
  
    float col_6 =  dot(texelFetchBuffer(LUT_coeffs, vInd + 9 ), vec4(Lc[36], Lc[37], Lc[38], Lc[39])) +
        dot(texelFetchBuffer(LUT_coeffs, vInd + 10 ), vec4(Lc[40], Lc[41], Lc[42], Lc[43])) +
        dot(texelFetchBuffer(LUT_coeffs, vInd + 11 ), vec4(Lc[44], Lc[45], Lc[46], Lc[47]));

    vec4 temp3 = texelFetchBuffer(LUT_coeffs, vInd + 12 );
    col_6 += temp3.x * Lc[48];
    col_6 *= 1.0171072;

    float col_7 = dot(temp3.yzw, vec3(Lc[49], Lc[50], Lc[51])) + 
        dot(texelFetchBuffer(LUT_coeffs, vInd + 13 ), vec4(Lc[52], Lc[53], Lc[54], Lc[55])) +
        dot(texelFetchBuffer(LUT_coeffs, vInd + 14 ), vec4(Lc[56], Lc[57], Lc[58], Lc[59])) + 
        dot(texelFetchBuffer(LUT_coeffs, vInd + 15 ), vec4(Lc[60], Lc[61], Lc[62], Lc[63]));
    col_7 *= 1.0925484; 
    
    float col_8 = dot(texelFetchBuffer(LUT_coeffs, vInd + 16 ), vec4(Lc[64], Lc[65], Lc[66], Lc[67])) +
        dot(texelFetchBuffer(LUT_coeffs, vInd + 17 ), vec4(Lc[68], Lc[69], Lc[70], Lc[71])) + 
        dot(texelFetchBuffer(LUT_coeffs, vInd + 18 ), vec4(Lc[72], Lc[73], Lc[74], Lc[75])) + 
        dot(texelFetchBuffer(LUT_coeffs, vInd + 19 ), vec4(Lc[76], Lc[77], Lc[78], Lc[79])) +
        (texelFetchBuffer(LUT_coeffs, vInd + 20 ).x * Lc[80]);
    col_8 *= 1.163107;
    
    float result = col_0 + col_1 + col_2 + col_3 + col_4 + col_5 + col_6 + col_7 + col_8;
    return max(0, result);

}

void main() {

    if (isBackground == 1) {
        gl_Position = vec4(position, 1);
        envCoord = position.xy * vec2(0.5, -0.5) + 0.5;
    }
    else if (isLight == 1) {
        gl_Position = projection * view * model * vec4(lightScale * position.xy, position.z, 1);
    }
    else {
        
        gl_Position = projection * view * model * vec4(position, 1);
    
        vec4 _pos = vec4(position, 1.0);
        pos = _pos.xyz / _pos.w ;
        float cArea = 0;


        float cRed = get_transfer_color(envRed);
        float cGreen = get_transfer_color(envGreen);
        float cBlue = get_transfer_color(envBlue);

        vec3 e1;
        vec3 e2;
        vec3 repLightVec;
        
        if (lightID == 1) {
            vec3 light1[5];
            light1[0] = normalize(lightSources[0] - pos);
            light1[1] = normalize(lightSources[1] - pos);
            light1[2] = normalize(lightSources[2] - pos);
            light1[3] = normalize(lightSources[3] - pos);

            float Lc[81] = polygonSH(light1, 4);

            cArea = 20 * get_transfer_color(Lc);       
            
            e1 = lightSources[1] - lightSources[0];
            e2 = lightSources[3] - lightSources[0];
            repLightVec = light1[0];
        } 

        T_color = vec3(0);
        vec3 lightNorm = cross(e1, e2);

        if (showEnv == 1) {
            T_color += vec3(cRed, cGreen, cBlue);
        }
        if (showArea == 1 ) {
            T_color += cArea * vec3(0.8, 0.3, 0);
        }
        
    }
    
}
