#version 330 core

in vec3 pos;
layout(location = 0) out vec3 px_color;
in vec3 N;
in vec3 T_color;
in vec2 envCoord;
in vec2 txCoord;

uniform int isBackground;
uniform int isLight;
uniform int showEnv;
uniform int IBL;
uniform vec3 eyePos;
uniform mat4 view;
uniform sampler2D envMap;

void main() {
	if (isBackground==1 && showEnv == 1) {
		if (IBL == 1) {
			px_color = texture(envMap, envCoord).xyz;
		}

	}
    else if (isLight==1) {
		if (gl_PrimitiveID <= 1) {
			px_color = vec3(0.8, 0.3, 0);
		}
		else if (gl_PrimitiveID <= 3) {
			px_color = vec3(.8, .3, .2);
		}
		else if (gl_PrimitiveID == 4) {
			px_color = vec3(.2, 0.3, 1);
		}
		else {
			px_color = vec3(0.2, 0.1, .6);
		}

		px_color = max(vec3(0), px_color - 0.004);
	    vec3 temp1 = px_color * (px_color * 6.2 + 0.5);
	    vec3 temp2 = px_color * (px_color * 6.2 + 1.7) + 0.06;
	    px_color = temp1 / temp2; 
    }
    else {
        px_color = T_color;

	    px_color = max(vec3(0), px_color - 0.004);
	    vec3 temp1 = px_color * (px_color * 6.2 + 0.5);
	    vec3 temp2 = px_color * (px_color * 6.2 + 1.7) + 0.06;
	    px_color = temp1 / temp2; 
    }
}
