/*
*
* Modified from sample code provided by Joey de Vries at https://learnopengl.com/,
* as permitted under CC BY-NC 4.0 license (https://creativecommons.org/licenses/by-nc/4.0/legalcode)
*
* Copyright (c) Joey de Vries (https://learnopengl.com/, https://twitter.com/JoeyDeVriez)
*/

#pragma once
// Std. Includes
#include <string>
#include <fstream>
#include <sstream>
#include <iostream>
#include <map>
#include <vector>
using namespace std;
// GL Includes
#include <GL/glew.h> // Contains all the necessery OpenGL includes
#include <glm/glm.hpp>
#include <glm/gtc/matrix_transform.hpp>
#include <SOIL/SOIL.h>
#include <assimp/Importer.hpp>
#include <assimp/scene.h>
#include <assimp/postprocess.h>

#include "Mesh.h"
#include "shader.h"

//GLint TextureFromFile(const char* path, string directory);

class Model {
public:
    /*  Functions   */
    // Constructor expects a filepath to a 3D model.
    Model(string basePath) {
        // this->loadModel(path);
        meshes.push_back(this->processMesh(basePath));
    }

    // Draws the model and all child meshes
    void Draw(Shader shader, int VAOid) {
        for(GLuint i = 0; i < this->meshes.size(); i++)
        this->meshes[i].Draw(shader, VAOid);
    }

    int numVertices;
    vector<char> indData;
    vector<char> posData;
    vector<char> normData;
    vector<char> coeffData;

private:
    /*  Model Data  */
    vector<Mesh> meshes;

    Mesh processMesh(string basePath) {
        vector<Vertex> vertices;
        vector<GLuint> indices;
        vector<Texture> textures;

        indData = readBinFile(basePath + "_ind");
        posData =  readBinFile(basePath + "_pos");
        normData =  readBinFile(basePath + "_norm");
        coeffData = readBinFile(basePath + "_coeff");

        numVertices = posData.size() / sizeof(float) / 3;

        char *byteData = &(posData[0]);
        float *mPositions = reinterpret_cast<float *> (byteData);

        byteData = &(indData[0]);
        uint32_t *mIndices = reinterpret_cast<uint32_t *> (byteData);

        byteData = &(normData[0]);
        float *mNormals = reinterpret_cast<float *> (byteData);

        int index = 0;
        for (int i = 0; i < numVertices; i++) {
            Vertex vertex;
            glm::vec3 vector; // Use placeholder vector to read out assimp vector values
            // Positions
            vector.x = mPositions[index];
            vector.y = mPositions[index + 1];
            vector.z = mPositions[index + 2];
            vertex.Position = 0.01 * vector;

            // Normals
            vector.x = mNormals[index];
            vector.y = mNormals[index + 1];
            vector.z = mNormals[index + 2];
            vertex.Normal = vector;

            vertex.Index = float(i);        // Try to replace this with primitive ID or something in the shader

            vertices.push_back(vertex);
            index += 3;
        }

        int numIndices = indData.size() / sizeof(uint32_t);
            
        // Get indices for all faces
        for(GLuint i = 0; i < numIndices; i++) {          
            indices.push_back(mIndices[i]);
        }

        cout << "num vertices: " << numVertices << endl;
        cout << "num indices: " << numIndices << endl;

        // Return a mesh object created from the extracted mesh data
        return Mesh(vertices, indices, textures);
    }

    vector<char> readBinFile(string filename) {
        ifstream infile(filename, ifstream::binary);
        infile.seekg(0, infile.end);
        int length = infile.tellg();
        infile.seekg(0, infile.beg);

        vector<char> buffer(length);
        infile.read(&buffer[0], length);

        return buffer;
    } 

};